'''
Przechowywanie pojedynczego towaru w aplikacji Modny ciuch
Towar ma cenę, poziom zapasów i zestaw tagów
które można wykorzystać do zlokalizowania tego towaru.
'''

import pickle

class StockItem(object):
    '''
    Towar magazynowy dla sklepu z odzieżą
    '''

    show_instrumentation = False

    min_price = 0.5 
    max_price = 500.0 

    max_stock_add = 50
    
    @staticmethod
    def get_tag_set_from_text(tag_string):
        '''
        Konwertuje listę rozdzielaną przecinkami na zbiór  
        pojedynczych pozycji
        Konwertuje tekst na wersję złożoną z małych liter i obcina 
        każde słowo
        '''
        # Konwertuje ciąg znaków na małe litery
        tag_string = str.lower(tag_string)

        # Tworzy listę wszystkich słów w ciągu
        # rozdzieloną przecinkiem
        tag_list = str.split(tag_string, sep=',')

        # Usuwa wszystkie spacje na początku lub
        # końcu każdego ciągu na liście
        tag_list = map(str.strip,tag_list)

        # zwraca zestaw utworzony na podstawie listy
        return set(tag_list)


    def __init__(self, stock_ref, price, tags):
        if StockItem.show_instrumentation:
            print('** Wywołano StockItem __init__')
        self.stock_ref = stock_ref
        self.__price = price
        self.__stock_level = 0
        self.StockItem_version = 1
        self.tags = tags

    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy StockItem')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        pass

    def __str__(self): 
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy StockItem')
        template = '''Numer magazynowy: {0}
Cena: {1}
Stock Level: {2}
Tags: {3}''' 

        return template.format(self.stock_ref, 
                               self.price, self.stock_level, 
                               self.tags) 

    def add_stock(self,count):
        '''
        Dodaje stan magazynowy dla tego produktu. 
        Count zawiera ilość towaru do dodania
        Zgłasza wyjątek, jeśli liczba jest nieprawidłowa
        '''
        if StockItem.show_instrumentation:
            print('** Wywołano metodę add_stock klasy StockItem')
        if count < 0 or count > StockItem.max_stock_add:
            raise Exception('Nieprawidłowa ilość towaru')

        self.__stock_level = self.__stock_level + count

    def sell_stock(self, count):
        '''
        Sprzedaż towaru.
        count zawiera liczbę towaru do sprzedania
        Zgłasza wyjątek, jeśli liczba jest nieprawidłowa
        '''
        if StockItem.show_instrumentation:
            print('** Wywołano metodę sell_stock klasy StockItem')
        if count < 1:
            raise Exception('Nieprawidłowa ilość towaru do sprzedaży')

        if count > self.stock_level:
            raise Exception('W magazynie nie ma wystarczającej ilości towaru')

        self.__stock_level = self.__stock_level - count

    def set_price(self, new_price):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę set_price klasy StockItem')
        if price < StockItem.min_price or price > StockItem.max_price:
            raise Exception('Cena poza zakresem')
            self.__price = new_price

    @property
    def price(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get price klasy StockItem')
        return self.__price

    @property
    def stock_level(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get stock_level klasy StockItem')
        return self.__stock_level

